package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import app.firezone.synk.network.Bgmi_Match_Activity;
import app.firezone.synk.network.FreeFireActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemGameDesignBinding;
import app.firezone.synk.network.model.GameModel;

public class GameAdapter extends RecyclerView.Adapter<GameAdapter.holder> {
    Context mContext;
    ArrayList<GameModel> mlist = new ArrayList<>();

    public GameAdapter(Context mContext, ArrayList<GameModel> mlist) {
        this.mContext = mContext;
        this.mlist = mlist;
    }


    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_game_design,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        GameModel model = mlist.get(position);

        holder.binding.gamename.setText(model.getGamename());
        holder.binding.totalPlayed.setText(model.getTotalPlayed());

        Picasso.get()
                .load(model.getImages())
                .placeholder(R.drawable.loading_img)
                .into(holder.binding.gameImg);




        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (model.getType().equals("Esports")){

                    Intent intent = new Intent(mContext, Bgmi_Match_Activity.class);
                    intent.putExtra("gamename",model.getGamename());
                    mContext.startActivity(intent);

                }else {
                    Intent intent = new Intent(mContext, FreeFireActivity.class);
                    intent.putExtra("gamename",model.getGamename());
                    mContext.startActivity(intent);
                }


            }
        });


    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {

        ItemGameDesignBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = ItemGameDesignBinding.bind(itemView);
        }
    }
}
